using Toybox.Background;
using Toybox.System as Sys;

// The Service Delegate is the main entry point for background processes
// our onTemporalEvent() method will get run each time our periodic event
// is triggered by the system.

(:background)
class BgbgServiceDelegate extends Toybox.System.ServiceDelegate {
	
	function initialize() {
		Sys.ServiceDelegate.initialize();
	}
	
    function onTemporalEvent() {
    	var now=Sys.getClockTime();
    	var ts=now.hour+":"+now.min.format("%02d");
    	var stats=Sys.getSystemStats();
       	Sys.println("background exit at "+ts+" battery="+stats.battery.format("%d")+" charging="+stats.charging);   
        Background.exit(ts);
    }
}
