using Toybox.WatchUi as Ui;
using Toybox.Graphics as Gfx;

(:glance)
class WidgetGlanceView extends Ui.GlanceView {
  hidden var _message as String = "123";
	
    function initialize() {
      WatchUi.GlanceView.initialize();
    }
    
    function onUpdate(dc) {
    	 dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_BLACK);
        dc.clear();
        dc.drawText(dc.getWidth() / 2, dc.getHeight() / 2, Graphics.FONT_MEDIUM, _message, Graphics.TEXT_JUSTIFY_CENTER | Graphics.TEXT_JUSTIFY_VCENTER);
    	 //dc.drawRectangle(0, 0, dc.getWidth(), dc.getHeight());
    }

    //! Show the result or status of the web request
    //! @param args Data from the web request, or error message
    public function onReceive(args as Dictionary or String or Null) as Void {
      System.println("onReceiveGlanceView");
      System.println("args "+args);
        if (args instanceof String) {
            _message = args;
            System.println("args1 "+args);
        } else if (args instanceof Dictionary) {
            // Print the arguments duplicated and returned by jsonplaceholder.typicode.com
            var keys = args.keys();
            System.println("args2 "+args);
            for (var i = 0; i < keys.size(); i++) {
                //_message += Lang.format("$1$: $2$\n", [keys[i], args[keys[i]]]);
                _message += Lang.format("$1$: $2$", [keys[i], args[keys[i]]]);
            }
        }
        System.println("message: "+_message);
        Ui.requestUpdate();
    }
}