using Toybox.WatchUi as Ui;
using Toybox.Graphics as Gfx;

// Represents a single key on the keyboard
class KeyboardKey {
    var label, value;
    var x, y, width, height;

    function initialize(label, x, y, width, height) {
        self.label = label;
        self.x = x;
        self.y = y;
        self.width = width;
        self.height = height;
    }
}

// Manages the layout and creation of keys
class KeyboardLayout {
    var keys;
    var keyboardState;

    function initialize(screenSize) {
        keys = [];
        keyboardState = 0;
        var screenWidth = screenSize[0];
        var screenHeight = screenSize[1];
        var keyWidth = (screenWidth-10) / 10; // 10 keys per row
        var keyHeight = screenHeight / 7; // 4 rows + some space
        var keyboardOffset = keyHeight * 3; // keyboard offset so as to place anywhere up and down

        // QWERTY keyboard layout
        // var row1 = "QWERTYUIOP";
        // var row2 = "ASDFGHJKL";
        // var row3 = "ZXCVBNM";
        // var row4 = "^space<";
        // var val = "";

        var row1 = [["q", "Q", "1"], ["w", "W", "2"], ["e", "E", "3"], ["r", "R", "4"], ["t", "T", "5"], ["y", "Y", "6"], ["u", "U", "7"], ["i", "I", "8"], ["o", "O", "9"], ["p", "P", "0"]];
        var row2 = [["a", "A", "+"], ["s", "S", "-"], ["d", "D", "*"], ["f", "F", "="], ["g", "G", "!"], ["h", "H", "#"], ["j", "J", "$"], ["k", "K", "%"], ["l", "L", ";"]];
        var row3 = [["z", "Z", "."], ["x", "X", ","], ["c", "C", "?"], ["v", "V", "("], ["b", "B", ")"], ["n", "N", "&"], ["m", "M", "\""]];
        var row4 = [["П", "П", "П"], ["space", "space", "space"], ["<-", "<-", "<-"]];
        var val = "";


        // Add keys for each row
        for (var i = 0; i < row1.size(); i++) {val = row1[i];
            keys.add(new KeyboardKey(val, i * keyWidth + 5, keyboardOffset, keyWidth, keyHeight));
        }
        for (var i = 0; i < row2.size(); i++) {val = row2[i];
            keys.add(new KeyboardKey(val, i * keyWidth + keyWidth/2, keyHeight + keyboardOffset, keyWidth, keyHeight));
        }
        for (var i = 0; i < row3.size(); i++) {val = row3[i];
            keys.add(new KeyboardKey(val, (i+1.5) * keyWidth, keyHeight*2 + keyboardOffset, keyWidth, keyHeight));
        }

        val = row4[0];
        keys.add(new KeyboardKey(val, 2 * keyWidth+keyWidth/2, keyHeight*3 + keyboardOffset, keyWidth, keyHeight));
        val = row4[1];
        keys.add(new KeyboardKey(val, 3 * keyWidth+keyWidth/2, keyHeight*3 + keyboardOffset, keyWidth*3, keyHeight));
        val = row4[2];
        keys.add(new KeyboardKey(val, 6 * keyWidth+keyWidth/2, keyHeight*3 + keyboardOffset, keyWidth, keyHeight));
    }
}