using Toybox.Application as App;
using Toybox.WatchUi as Ui;

class Notepad2App extends App.AppBase {
    var view;
    var delegate;

    function initialize() {
        AppBase.initialize();
        view = new FullTextView(); // Create view without parameters
        delegate = new FullTextDelegate(view);
    }

    // Load persistent messageBuffer when the app starts
    function onStart(state) as Void {
        if (App.Storage.getValue("messageBuffer") == null) {
            App.Storage.setValue("messageBuffer", "");
        }
    }

    function onStop(state) as Void {
        App.Storage.setValue("messageBuffer", view.messageBuffer); // Store persistently
        System.println("exited");
        System.exit();
    }

    function getInitialView() {
        view.messageBuffer = App.Storage.getValue("messageBuffer");
        // Push the view and delegate
        return [view, delegate];
    }
}