using Toybox.WatchUi as Ui;
using Toybox.System as Sys;
using Toybox.Application as App;

class FullTextDelegate extends Ui.BehaviorDelegate {
    var messageBuffer;
    var view;

    function initialize(viewInstance) {
        BehaviorDelegate.initialize();
        view = viewInstance; // Store the view instance
    }

    // Action button to go to edit
    function onSelect(){
        // Push the new full-text view
        var editView = new EditView(view);
        var editDelegate = new EditDelegate(editView.keyboardLayout, editView);
        Ui.pushView(editView, editDelegate, Ui.SLIDE_IMMEDIATE);
        return true;
    }

    // Scroll handling (if you want to add touch scrolling)
    // function onSwipe(swipeEvent) as Boolean {
    //     var direction = swipeEvent.getDirection();
    //     // Add scrolling logic here based on direction
    //     return true;
    // }
}