using Toybox.WatchUi as Ui;
using Toybox.Graphics as Gfx;
using Toybox.System as Sys;
using Toybox.Lang as Lang;
using Toybox.Application as App; // Added for persistence

class EditView extends Ui.View {
    var bmp = Ui.loadResource(Rez.Drawables.backspace);
    var bmpX = 50;
    var bmpY = 100;
    var bmpSize = 32;
    var buttonWidth = 100;
    var buttonHeight = 40;
    var keyboardLayout;
    var textView;

    function initialize(view) {
        View.initialize();
        textView = view; // keep a copy to update the viewing page's messageBuffer
        // Get screen size to create a dynamic layout
        var screenWidth = System.getDeviceSettings().screenWidth;
        var screenHeight = System.getDeviceSettings().screenHeight;
        keyboardLayout = new KeyboardLayout([screenWidth, screenHeight]);
    }

    function onUpdate(dc) {
        dc.setColor(Gfx.COLOR_WHITE, Gfx.COLOR_BLACK);
        dc.clear();
        

        // ___DRAW THE KEYBOARD___
        // Draw each key
        for (var i = 0; i < keyboardLayout.keys.size(); i++) {
            var key = keyboardLayout.keys[i];
            
            // Draw the key background
            dc.setColor(Gfx.COLOR_LT_GRAY, Gfx.COLOR_LT_GRAY);
            dc.fillRoundedRectangle(key.x + 2, key.y + 2, key.width - 4, key.height - 4, 5);

            // Draw the key label
            dc.setColor(Gfx.COLOR_BLACK, Gfx.COLOR_TRANSPARENT);
            dc.drawText(
                key.x + key.width / 2,
                key.y + key.height / 2,
                Gfx.FONT_SMALL,
                key.label[keyboardLayout.keyboardState],
                Gfx.TEXT_JUSTIFY_CENTER | Gfx.TEXT_JUSTIFY_VCENTER
            );
        }

        // ___DRAW THE TEXT (MESSAGE BUFFER)___
        // Handle message buffer truncation
        var maxWidth = dc.getWidth() - 40; // leave space for the backspace button
        var shownText = "";

        // Split buffer into lines
        var lines = split(textView.messageBuffer, "\n");
        if (lines.size()>1) {shownText="...";}
        shownText += lines[lines.size() - 1]; // last line only

        // Shrink from left until it fits
        while (dc.getTextDimensions(shownText, Gfx.FONT_MEDIUM)[0] > maxWidth && shownText.length() > 0) {
            shownText = shownText.substring(1, shownText.length());
        }

        // Draw the buffer text (aligned left side, vertical offset at 65)
        dc.setColor(Gfx.COLOR_WHITE, Gfx.COLOR_TRANSPARENT);
        dc.drawText(15, 65, Gfx.FONT_MEDIUM, shownText, Gfx.TEXT_JUSTIFY_LEFT);

        // ___DRAW THE BACKSPACE IMAGE___
        bmpX = dc.getWidth() - bmp.getWidth() - 10;
        bmpY = 85 - (bmp.getHeight() / 2); // vertically center relative to text baseline

        dc.drawBitmap(bmpX, bmpY, bmp);

        // ___DRAW THE SEPARATOR line under text area ___
        dc.drawRectangle(0, 102, dc.getWidth(), 1);

    }

    // Method to update the message buffer from the delegate
    function updateBuffer(buffer as Lang.String) {
        textView.messageBuffer = buffer;
        Ui.requestUpdate(); // Request a redraw to show the updated buffer
    }

    function split(s, sep) {
        var tokens = [];
        var found = s.find(sep);

        while (found != null) {
            var token = s.substring(0, found);
            tokens.add(token);
            s = s.substring(found + sep.length(), s.length());
            found = s.find(sep);
        }

        tokens.add(s); // Add the last token

        return tokens;
    }
}