import Toybox.Activity;
import Toybox.Graphics;
import Toybox.Lang;
import Toybox.WatchUi;
import Toybox.Sensor;
import Toybox.Background;
import Toybox.Time;

var tempEdge = 99.0f;   

class TemperatureView extends WatchUi.DataField {

    function initialize() {
        DataField.initialize();
    }

    function onUpdate(dc as Dc) as Void {
        var fieldWidth = dc.getWidth();
        var fieldHeight = dc.getHeight();
        var textCenter = Graphics.TEXT_JUSTIFY_CENTER | Graphics.TEXT_JUSTIFY_CENTER;  //VCENTER
        var backgroundColor = getBackgroundColor();
        var foregroundColor = (backgroundColor == Graphics.COLOR_BLACK) ? Graphics.COLOR_WHITE : Graphics.COLOR_BLACK;
        // set Color        
        dc.setColor(foregroundColor, Graphics.COLOR_TRANSPARENT);

        var showTemp = "--";
        var tempCorr = 0.0f;
        var tCorr = Application.Properties.getValue("_tempCorr");
        if ( tCorr != null ) {
            tempCorr = tCorr.toFloat();
        } else {
            tempCorr = 0.0;
        }    
        System.println("TempCorr: " + tempCorr);
        if ( tempEdge < 99 ) {
            showTemp = ( tempEdge + tempCorr ).format("%.1f");  
        }   
        dc.drawText(fieldWidth / 2, fieldHeight / 2 - 15 , Graphics.FONT_LARGE, showTemp + " °C", textCenter); 
        
    }

}
