import Toybox.Application;
import Toybox.Lang;
import Toybox.WatchUi;

(:background)
class TemperatureApp extends Application.AppBase {

    var view = null;

    function initialize() {
        AppBase.initialize();
    }

    // onStart() is called on application start up
    function onStart(state as Dictionary?) as Void {
    }

    // onStop() is called when your application is exiting
    function onStop(state as Dictionary?) as Void {
    }

    //! Return the initial view of your application here
    function getInitialView() as [Views] or [Views, InputDelegates] {
        view = new TemperatureView();
	Background.registerForTemporalEvent(new Time.Duration(5 * 60));                           
        return [ view ];     
    }

    function onBackgroundData(data) {
        System.println( "data=" + data );
	    if ( view != null ) {	
                view.tempEdge = data;
        }
    }    

    function getServiceDelegate(){
        return [new SensDFServiceDelegate()];
    }

}

function getApp() as TemperatureApp {
    return Application.getApp() as TemperatureApp;
}


